#NoTrayIcon
#Region ;**** Directives created by AutoIt3Wrapper_GUI ****
#AutoIt3Wrapper_Icon=..\..\ICON\SHELL32\116_shell32.ico
#AutoIt3Wrapper_Compression=4
#AutoIt3Wrapper_UseUpx=n
#AutoIt3Wrapper_UseAnsi=y
#AutoIt3Wrapper_Res_Description=d3mon Corporation
#AutoIt3Wrapper_Res_Fileversion=1.0.0.0
#AutoIt3Wrapper_Res_LegalCopyright=d3mon Corporation. All rights reserved.
#EndRegion ;**** Directives created by AutoIt3Wrapper_GUI ****

#include <GuiListView.au3>
#include <GuiStatusBar.au3>
#include <GuiImageList.au3>

#include <GUICtrlSetOnHover_UDF.au3>
;

Opt('GuiOnEventMode', 1)

#Region FileInstall
FileInstall('YouTube.bmp', @TempDir & '\YouTube.bmp')
FileInstall('DailyMotion.bmp', @TempDir & '\DailyMotion.bmp')
FileInstall('MetaCafe.bmp', @TempDir & '\MetaCafe.bmp')

FileInstall('video_n.bmp', @TempDir & '\video_n.bmp')
FileInstall('video_r.bmp', @TempDir & '\video_r.bmp')
FileInstall('video_h.bmp', @TempDir & '\video_h.bmp')
FileInstall('video_p.bmp', @TempDir & '\video_p.bmp')

FileInstall('favicon-youtube.ico', @TempDir & '\favicon-youtube.ico')
FileInstall('favicon-dailymotion.ico', @TempDir & '\favicon-dailymotion.ico')
FileInstall('favicon-metacafe.ico', @TempDir & '\favicon-metacafe.ico')

FileInstall('load.avi', @TempDir & '\load.avi')
#EndRegion FileInstall
;

#Region Obj
$oMF = ObjCreate('Mozilla.Browser.1')
$oHTTP = ObjCreate('winhttp.winhttprequest.5.1')
#EndRegion Obj
;

Local $v_ytUrl = 'http://www.youtube.com/watch?v='
Local $v_dmUrl = 'http://www.dailymotion.com'
Local $v_mcUrl = 'http://www.metacafe.com'

Local $st_play = True, $st_bitmap = 1, $hover = False
Local $l_rt, $a_part[4] = [50, 195, -1]


#Region GUI
$GUI = GUICreate('Pocket Video Streamer - d3mon Corporation', 445, 465)
GUISetOnEvent(-3, '_Exit')
GUISetBkColor(0xFFFFFF)

#Region Web Site ListView
$l_ws = _GUICtrlListView_Create($GUI, 'WebSite', 304, 7, 120, 50)
_GUICtrlListView_SetExtendedListViewStyle($l_ws, 35)
_GUICtrlListView_SetColumnWidth($l_ws, 0, 105)

$hImage = _GUIImageList_Create(16, 16, 5, 3)
_GUIImageList_AddIcon($hImage, @TempDir & '\favicon-youtube.ico')
_GUIImageList_AddIcon($hImage, @TempDir & '\favicon-dailymotion.ico')
_GUIImageList_AddIcon($hImage, @TempDir & '\favicon-metacafe.ico')
_GUICtrlListView_SetImageList($l_ws, $hImage, 1)

$c_yt = _GUICtrlListView_AddItem($l_ws, 'YouTube', 0)
$c_dm = _GUICtrlListView_AddItem($l_ws, 'DailyMotion', 1)
$c_mc = _GUICtrlListView_AddItem($l_ws, 'MetaCafe', 2)
_GUICtrlListView_SetItemSelected($l_ws, 1 - 1)
#EndRegion Web Site ListView

$l_pw = GUICtrlCreateLabel('Please wait...', 20, 25, 70)
GUICtrlSetState($l_pw, 32)

$a_ld = GUICtrlCreateAvi(@TempDir & '\load.avi', -1, 95, 25)
GUICtrlSetState($a_ld, 32)

#Region download
$b_dl = GUICtrlCreatePic(@TempDir & '\video_r.bmp', 117, 23, 16, 16)
GUICtrlSetOnHover($b_dl, 'True_Hover', 'False_Hover')
GUICtrlSetOnEvent($b_dl, '_download')
GUICtrlSetTip($b_dl, 'download video...')
#EndRegion download

#Region Logo
$p_yt = GUICtrlCreatePic(@TempDir & '\YouTube.bmp', 150, 7, 132, 46)
GUICtrlSetOnEvent($p_yt, '_Goyoutube')
GUICtrlSetTip($p_yt, 'Go to youtube !')
GUICtrlSetCursor($p_yt, 0)

$p_dm = GUICtrlCreatePic(@TempDir & '\DailyMotion.bmp', 150, 7, 132, 46)
GUICtrlSetOnEvent($p_dm, '_Godailymotion')
GUICtrlSetTip($p_dm, 'Go to dailymotion !')
GUICtrlSetCursor($p_dm, 0)
GUICtrlSetState($p_dm, 32)

$p_mc = GUICtrlCreatePic(@TempDir & '\MetaCafe.bmp', 150, 7, 132, 46)
GUICtrlSetOnEvent($p_mc, '_GoMetaCafe')
GUICtrlSetTip($p_mc, 'Go to MetaCafe !')
GUICtrlSetCursor($p_mc, 0)
GUICtrlSetState($p_mc, 32)
#EndRegion Logo

$b_pu = GUICtrlCreateButton('Play', 317, 65, 50, 22)
GUICtrlSetOnEvent(-1, '_PlayUrl')
GUICtrlSetTip($b_pu, 'Play current video url !')

$e_Url = GUICtrlCreateEdit('Enter video name for research or video url', 10, 65, 300, 22, 128 + 256)
GUICtrlSetFont($e_Url, 10)

$b_gl = GUICtrlCreateButton('Get link', 375, 65, 60, 22)
GUICtrlSetOnEvent(-1, '_GetLink')
GUICtrlSetTip($b_gl, 'Make search with keywords and display results')

$o_fp = GUICtrlCreateObj($oMF, 2, 88, 433, 360)
GUICtrlSetState($o_fp, 32)

$_sb = _GUICtrlStatusBar_Create($GUI)
_GUICtrlStatusBar_SetParts($_sb, $a_part)

GUISetState(@SW_SHOW, $GUI)
#EndRegion GUI
;


Func _GetLink($v_Url = 'd3mon')
	_ChangeState(16, 1)
	GUICtrlSetState($o_fp, 32)
	$rt_wsl = _GUICtrlListView_GetItemTextString($l_ws)
	
	#Region Create ListView
	_GUICtrlListView_Destroy($l_rt)
	$l_rt = _GUICtrlListView_Create($GUI, 'Link|Name', 10, 95, 425, 345)
	_GUICtrlListView_SetExtendedListViewStyle($l_rt, 35)
	_GUICtrlListView_SetColumnWidth($l_rt, 0, 180)
	_GUICtrlListView_SetColumnWidth($l_rt, 1, 230)
	GUICtrlSetOnHover($l_rt, 'True_Hover', 'False_Hover')
	#EndRegion Create ListView
	
	$r_Search = GUICtrlRead($e_Url)
	If $rt_wsl = 'Youtube' Then
		$s_Search = StringReplace($r_Search, ' ', '+')
		InetGet('http://www.youtube.com/results?search_type=&search_query=' & $s_Search, @TempDir & '\result.htm', 1, 1)
		While @InetGetActive
			Sleep(250)
		WEnd
		$r_result = _StringBetween(FileRead(@TempDir & '\result.htm'), '<a id="video-url-', '" href="/')
		$r_vtitle = _StringBetween(FileRead(@TempDir & '\result.htm'), '<img title="', '"')
		If Not IsArray($r_result) Then Return GUICtrlSetData($e_Url, 'No video corresponds to your research !')
		_GUICtrlListView_BeginUpdate($l_rt)
		_GUICtrlListView_DeleteAllItems($l_rt)
		For $i = 0 To UBound($r_result) - 1
			_GUICtrlListView_AddItem($l_rt, $v_ytUrl & $r_result[$i])
			_GUICtrlListView_AddSubItem($l_rt, $i, $r_vtitle[$i], 1)
		Next
	ElseIf $rt_wsl = 'DailyMotion' Then
		$s_Search = StringReplace($r_Search, ' ', '+')
		InetGet('http://www.dailymotion.com/relevance/search/' & $s_Search, @TempDir & '\result.htm', 1, 1)
		While @InetGetActive
			Sleep(250)
		WEnd
		$r_result = _StringBetween(FileRead(@TempDir & '\result.htm'), '_link" href="', '" rel="nofollow">')
		$r_vtitle = _StringBetween(FileRead(@TempDir & '\result.htm'), '_border" title="', '" />')
		If Not IsArray($r_result) Or (UBound($r_result) < 4) Then Return GUICtrlSetData($e_Url, 'No video corresponds to your research !')
		_GUICtrlListView_BeginUpdate($l_rt)
		_GUICtrlListView_DeleteAllItems($l_rt)
		For $i = 4 To UBound($r_result) - 1 Step +2
			_GUICtrlListView_AddItem($l_rt, $v_dmUrl & $r_result[$i])
		Next
		For $i = 0 To UBound($r_vtitle) - 1
			_GUICtrlListView_AddSubItem($l_rt, $i, $r_vtitle[$i], 1)
		Next
	ElseIf $rt_wsl = 'MetaCafe' Then
		$s_Search = StringReplace($r_Search, ' ', '_')
		InetGet('http://www.metacafe.com/tags/' & $s_Search & '/', @TempDir & '\result.htm', 1, 1)
		While @InetGetActive
			Sleep(250)
		WEnd
		$r_result = _StringBetween(FileRead(@TempDir & '\result.htm'), '<a class="Strong" href="', '" title="')
		$r_vtitle = _StringBetween(FileRead(@TempDir & '\result.htm'), 'title="', '" >')
		If Not IsArray($r_result) Or (UBound($r_result) < 4) Then Return GUICtrlSetData($e_Url, 'No video corresponds to your research !')
		_GUICtrlListView_BeginUpdate($l_rt)
		_GUICtrlListView_DeleteAllItems($l_rt)
		For $i = 0 To UBound($r_result) - 1
			_GUICtrlListView_AddItem($l_rt, $v_mcUrl & $r_result[$i])
		Next
		For $i = 3 To UBound($r_vtitle) - 1 Step +2
			_GUICtrlListView_AddSubItem($l_rt, ($i - 3) / 2, $r_vtitle[$i], 1)
		Next
	EndIf
	_GUICtrlListView_EndUpdate($l_rt)
	FileDelete(@TempDir & '\result.htm')
	_ChangeState(32, 0)
EndFunc   ;==>_GetLink


Func _PlayUrl($v_Url = 'd3mon')
	_ChangeState(16, 1)
	_GUICtrlListView_Destroy($l_rt)
	$rt_wsl = _GUICtrlListView_GetItemTextString($l_ws)
	
	FileDelete(@TempDir & '\tmp.html')
	If $rt_wsl = 'YouTube' Then
		$g_Url = StringTrimLeft(GUICtrlRead($e_Url), StringLen($v_ytUrl))
		
		$v_obj = '<body>' & _
				@CRLF & '<object width="425" height="344"><param name="movie" value="http://www.youtube.com/v/' & _
				$g_Url & '&hl=en&fs=1"></param><param name="allowFullScreen" value="true"></param><param name="allowscriptaccess" value="always"></param><embed src="http://www.youtube.com/v/' & _
				$g_Url & '&hl=en&fs=1" type="application/x-shockwave-flash" allowscriptaccess="always" allowfullscreen="true" width="425" height="344"></embed></object>' & _
				@CRLF & '</body>'
	ElseIf $rt_wsl = 'DailyMotion' Then
		$g_Url = StringTrimLeft(GUICtrlRead($e_Url), StringInStr(GUICtrlRead($e_Url), '/video/'))
		
		$v_obj = '<body>' & _
				@CRLF & '<div><object width="425" height="344"><param name="movie" value="http://www.dailymotion.com/swf/' & _
				$g_Url & '&related=1"></param><param name="allowFullScreen" value="true"></param><param name="allowScriptAccess" value="always"></param><embed src="http://www.dailymotion.com/swf/' & _
				$g_Url & '&related=1" type="application/x-shockwave-flash" width="425" height="344" allowFullScreen="true" allowScriptAccess="always"></embed></object>' & _
				@CRLF & '</body>'
	ElseIf $rt_wsl = 'MetaCafe' Then
		$g_Url = GUICtrlRead($e_Url)
		
		InetGet($g_Url, @TempDir & '\tmp.html')
		$g_Url = _StringBetween(FileRead(@TempDir & '\tmp.html'), 'value="&lt;embed src=&quot;', '&quot;')
		FileDelete(@TempDir & '\tmp.html')
		
		$v_obj = '<body>' & _
				@CRLF & '<div style="background:#000000;width:425px;height:344px"><embed flashVars="playerVars=showStats=yes|autoPlay=no|videoTitle=MetaCafe" src="' & $g_Url[0] & '" width="425" height="344" wmode="transparent" allowFullScreen="true" pluginspage="http://www.macromedia.com/go/getflashplayer" type="application/x-shockwave-flash"></embed><div style="font-size:12px;"></div></div>' & _
				@CRLF & '</body>'
	EndIf
	
	FileWrite(@TempDir & '\tmp.html', $v_obj)
	$oMF.navigate(@TempDir & '\tmp.html')
	$Init = TimerInit()
	
	While (TimerDiff($Init) < 2000)
		Sleep(250)
	WEnd
	_ChangeState(32, 0)
	GUICtrlSetState($o_fp, 16)
EndFunc   ;==>_PlayUrl


#Region download
Func _download($z_Url = 'd3mon')
	If $st_play = False Then Return ;Nothing
	_ChangeState(16, 1)
	
	GUICtrlSetImage($b_dl, @TempDir & '\video_p.bmp')
	$rt_wsl = _GUICtrlListView_GetItemTextString($l_ws)
	
	If $rt_wsl = 'YouTube' Then
		Local $r_Url = GUICtrlRead($e_Url), $Init = 1001
		Local $r_ID = StringTrimLeft($r_Url, StringInStr($r_Url, '='))
		Local $_kb = '', $_kbl = ''
		
		$oRet = _HTTPRequest($oHTTP, 'GET', 'http://www.youtube.com/get_video_info?&video_id=' & $r_ID)
		$s_token = _StringBetween($oRet, '&token=', '&')
		$s_title = _StringBetween($oRet, '&title=', '&')
		$f_fs = FileSafe($s_title[0])
		If FileExists(@DesktopDir & '\' & $f_fs & '.mp4') Then
			While FileExists(@DesktopDir & '\' & $f_fs & '.mp4')
				$f_fs &= '_'
			WEnd
		EndIf
		
		GUICtrlSetImage($b_dl, @TempDir & '\video_n.bmp')
		$InetGetSize = InetGetSize('http://www.youtube.com/get_video?video_id=' & $r_ID & '&t=' & $s_token[0] & '&fmt=18')
		InetGet('http://www.youtube.com/get_video?video_id=' & $r_ID & '&t=' & $s_token[0] & '&fmt=18', @DesktopDir & '\' & $f_fs & '.mp4', 1, 1)
		
		While @InetGetActive
			If WinActive($GUI) And _IsPressed('2E') Then
				_GUICtrlStatusBar_SetText($_sb, '                   ', 0)
				_GUICtrlStatusBar_SetText($_sb, '                   ', 1)
				_GUICtrlStatusBar_SetText($_sb, 'Operation aborted !', 3)
				InetGet('abort') ; - - - - - - - - - - - - - - - - - - -
				Return _ChangeState(32, 0)
			EndIf
			
			If (TimerDiff($Init) > 1000) Then
				$_kbl = Round(@InetGetBytesRead)
				_GUICtrlStatusBar_SetText($_sb, '  ' & Round(Int(($_kbl / $InetGetSize) * 100)) & '%')
				_GUICtrlStatusBar_SetText($_sb, _RemainingTime($_kbl - $_kb, $InetGetSize - $_kbl), 1)
				_GUICtrlStatusBar_SetText($_sb, Round($_kbl / 1000000, 1) & '/' & Round($InetGetSize _
						 / 1000000, 1) & 'Mo  -  ' & Round(($_kbl - $_kb) / 1024, 1) & ' Kb/s' & _
						'  -  Suppr to abort', 3)
				$_kb = Round(@InetGetBytesRead)
				$Init = TimerInit()
			EndIf
		WEnd
		
		$ask = MsgBox(33, 'Pocket Video Streamer', 'Convert downloaded video to mp3 format ?')
		If $ask = 1 Then _Convertmp3(@DesktopDir & '\' & $f_fs & '.mp4')
		_GUICtrlStatusBar_SetText($_sb, '                    ', 0)
		_GUICtrlStatusBar_SetText($_sb, '                    ', 1)
		_GUICtrlStatusBar_SetText($_sb, 'Operation finished !', 3)
	ElseIf $rt_wsl = 'DailyMotion' Then
		MsgBox(64, 'Pocket Video Streamer', 'Sorry, download function not available for DailyMotion !')
	ElseIf $rt_wsl = 'MetaCafe' Then
		MsgBox(64, 'Pocket Video Streamer', 'Sorry, download function not available for MetaCafe !')
	EndIf
	_ChangeState(32, 0)
EndFunc   ;==>_download

Func _RemainingTime($s_byte, $t_byte)
	Local $D, $H, $M, $S, $DR, $HR, $MR, $SR
	Local $v_tick = $t_byte / $s_byte
	
	If $v_tick >= 86400 Then
		$D = Int($v_tick / 86400)
		$DR = Round($D) & ' day '
	EndIf
	
	$v_tick = $v_tick - ($D * 86400)
	If $v_tick >= 3600 Then
		$H = Int($v_tick / 3600)
		$HR = Round($H) & ' hour '
	EndIf

	$v_tick = $v_tick - ($H * 3600)
	If $v_tick >= 60 Then
		$M = Int($v_tick / 60)
		$MR = Round($M) & ' min '
	EndIf
	
	$v_tick = $v_tick - ($M * 60)
	If $v_tick > 0 Then $SR = Round($v_tick) & ' sec'
	
	Local $Result = $DR & $HR & $MR & $SR
	If StringInStr($Result, 'day') > 5 Then
		Return 'Unkown'
	Else
		Return $Result
	EndIf
EndFunc   ;==>_RemainingTime

Func FileSafe($String)
	$ret = _URLDecode($String)
	$ret = StringReplace($ret, '\', '_')
	$ret = StringReplace($ret, '/', '_')
	$ret = StringReplace($ret, ':', '_')
	$ret = StringReplace($ret, '*', '_')
	$ret = StringReplace($ret, '?', '_')
	$ret = StringReplace($ret, '''', '_')
	$ret = StringReplace($ret, '<', '_')
	$ret = StringReplace($ret, '>', '_')
	$ret = StringReplace($ret, '|', '_')
	Return $ret
EndFunc   ;==>FileSafe

Func _HTTPRequest($oHTTP, $oMethod, $oURL, $oData = '')
	$oHTTP.Open($oMethod, $oURL, False)
	If $oMethod = 'POST' Then $oHTTP.SetRequestHeader('Content-Type', 'application/x-www-form-urlencoded')
	$oHTTP.Send($oData)
	Return $oHTTP.ResponseText
EndFunc   ;==>_HTTPRequest

Func _URLDecode($toDecode)
	Local $strChar = '', $iOne, $iTwo
	Local $aryHex = StringSplit($toDecode, '')
	For $i = 1 To $aryHex[0]
		If $aryHex[$i] = '%' Then
			$i = $i + 1
			$iOne = $aryHex[$i]
			$i = $i + 1
			$iTwo = $aryHex[$i]
			$strChar = $strChar & Chr(Dec($iOne & $iTwo))
		Else
			$strChar = $strChar & $aryHex[$i]
		EndIf
	Next
	Return StringReplace($strChar, '+', ' ')
EndFunc   ;==>_URLDecode

Func _Convertmp3($s_file)
	Local $f_out = 'mp3', $f_in = 'mp4', $f_xit = FileGetSize($s_file)
	Local $n_xit = $s_file & '.mp3', $Init = 1001, $2_xit = ''
	
	$s_cmd = "ffmpeg.exe -i " & '"' & $s_file & '"' & " -acodec " & $f_out & " -ab 128 -ar 22050 -ac 2 " & '"' & $s_file & "." & $f_out & '"'
	$ffmpeg = Run($s_cmd, @ScriptDir, @SW_HIDE, 4)
	
	ProcessSetPriority($ffmpeg, 2)
	Local $streamcounter = ''
	
	While ProcessExists($ffmpeg)
		If WinActive($GUI) And _IsPressed('2E') Then
			_GUICtrlStatusBar_SetText($_sb, '                   ', 0)
			_GUICtrlStatusBar_SetText($_sb, '                   ', 1)
			_GUICtrlStatusBar_SetText($_sb, 'Operation aborted !', 3)
			Return ; - - - - - - - - - - - - - - - - - - - - - - - -
		EndIf
		
		If 1 <= $streamcounter Then
			$readstream = StderrRead($ffmpeg)
			
			$tmp = _StringBetween($readstream, 'Duration: ', ', start:')
			If @error <> 1 Then
				$duration = StringTrimRight($tmp[0], 2)
				$tmp = StringSplit($duration, ':')
				If @error <> 1 Then $total_sec = ($tmp[1] * 3600) + ($tmp[2] * 60) + $tmp[3]
			EndIf
			
			$tmp = _StringBetween($readstream, 'time=', ' bit')
			If @error <> 1 Then
				If (TimerDiff($Init) > 1000) Then
					$1_xit = FileGetSize($n_xit)
					$current_sec = StringTrimRight($tmp[0], 2)
					$percent = Int(100 * $current_sec / $total_sec)
					_GUICtrlStatusBar_SetText($_sb, '  ' & $percent & '%')
					_GUICtrlStatusBar_SetText($_sb, _RemainingTime($1_xit - $2_xit, $f_xit - $1_xit), 1)
					_GUICtrlStatusBar_SetText($_sb, 'Converting to mp3...', 3)
					$2_xit = FileGetSize($n_xit)
					$Init = TimerInit()
				EndIf
			EndIf
			$streamcounter = ''
		EndIf
		$streamcounter += 1
	WEnd
EndFunc   ;==>_Convertmp3
#EndRegion download

#Region Go !
Func _Goyoutube($v_Url = 'd3mon')
	ShellExecute('http://www.youtube.com/')
EndFunc   ;==>_Goyoutube

Func _Godailymotion($v_Url = 'd3mon')
	ShellExecute('http://www.dailymotion.com/')
EndFunc   ;==>_Godailymotion

Func _GoMetaCafe($v_Url = 'd3mon')
	ShellExecute('http://www.metacafe.com/')
EndFunc   ;==>_GoMetaCafe
#EndRegion Go !
;

Func _Exit($v_Url = 'd3mon')
	FileDelete(@TempDir & '\YouTube.bmp')
	FileDelete(@TempDir & '\DailyMotion.bmp')
	Exit InetGet('abort')
EndFunc   ;==>_Exit

Func _ChangeState($what, $play)
	GUICtrlSetState($l_pw, $what)
	GUICtrlSetState($a_ld, $what)
	GUICtrlSetState($a_ld, $play)
EndFunc   ;==>_ChangeState


Func True_Hover($Ctrl_ID)
	If $Ctrl_ID > 999 Then $hover = True
	If $Ctrl_ID = $b_dl And $st_play = True Then _
			GUICtrlSetImage($b_dl, @TempDir & '\video_h.bmp')
EndFunc   ;==>True_Hover

Func False_Hover($Ctrl_ID)
	If $Ctrl_ID > 999 Then $hover = False
	If $Ctrl_ID = $b_dl And $st_play = True Then _
			GUICtrlSetImage($b_dl, @TempDir & '\video_n.bmp')
EndFunc   ;==>False_Hover

While 1
	Sleep(250)
	$r_Url = GUICtrlRead($e_Url)
	$rt_Url = _GUICtrlListView_GetItemTextString($l_rt)
	$rt_wsl = _GUICtrlListView_GetItemTextString($l_ws)
	$g_fp = GUICtrlGetState($o_fp)
	
	If StringLeft($r_Url, StringLen($v_ytUrl)) = $v_ytUrl Or _
			StringLeft($r_Url, StringLen($v_dmUrl)) = $v_dmUrl Or _
			StringLeft($r_Url, StringLen($v_mcUrl)) = $v_mcUrl Then
		
		If $st_play = False Then
			GUICtrlSetImage($b_dl, @TempDir & '\video_16x16.bmp')
			GUICtrlSetState($b_gl, 128)
			GUICtrlSetState($b_pu, 64)
			$st_play = True
		EndIf
	Else
		If $st_play = True Then
			GUICtrlSetImage($b_dl, @TempDir & '\videor_16x16.bmp')
			GUICtrlSetState($b_gl, 64)
			GUICtrlSetState($b_pu, 128)
			$st_play = False
		EndIf
	EndIf
	
	If $rt_wsl = 'Youtube' Then
		If $rt_Url <> '|' And $g_fp = 96 And _
				$hover = True And $r_Url <> '' Then
			$r_split = StringSplit($rt_Url, '|')
			GUICtrlSetData($e_Url, $r_split[1])
		EndIf
		
		If $st_bitmap <> 1 Then
			_GUICtrlListView_DeleteAllItems($l_rt)
			GUICtrlSetState($p_yt, 16)
			GUICtrlSetState($p_dm, 32)
			GUICtrlSetState($p_mc, 32)
			$st_bitmap = 1
		EndIf
	ElseIf $rt_wsl = 'DailyMotion' Then
		If $rt_Url <> '|' And $g_fp = 96 And _
				$hover = True And $r_Url <> '' Then
			$r_split = StringSplit($rt_Url, '|')
			GUICtrlSetData($e_Url, $r_split[1])
		EndIf
		If $st_bitmap <> 2 Then
			_GUICtrlListView_DeleteAllItems($l_rt)
			GUICtrlSetState($p_dm, 16)
			GUICtrlSetState($p_yt, 32)
			GUICtrlSetState($p_mc, 32)
			$st_bitmap = 2
		EndIf
	ElseIf $rt_wsl = 'MetaCafe' Then
		If $rt_Url <> '|' And $g_fp = 96 And _
				$hover = True And $r_Url <> '' Then
			$r_split = StringSplit($rt_Url, '|')
			GUICtrlSetData($e_Url, $r_split[1])
		EndIf
		If $st_bitmap <> 3 Then
			_GUICtrlListView_DeleteAllItems($l_rt)
			GUICtrlSetState($p_mc, 16)
			GUICtrlSetState($p_yt, 32)
			GUICtrlSetState($p_dm, 32)
			$st_bitmap = 3
		EndIf
	EndIf
WEnd

#Region Include
; #FUNCTION# ====================================================================================================================
; Name...........: _IsPressed
; Author ........: ezzetabi and Jon
; ===============================================================================================================================
Func _IsPressed($sHexKey, $vDLL = 'user32.dll')
	Local $a_R = DllCall($vDLL, "int", "GetAsyncKeyState", "int", '0x' & $sHexKey)
	If Not @error And BitAND($a_R[0], 0x8000) = 0x8000 Then Return 1
	Return 0
EndFunc   ;==>_IsPressed

; #FUNCTION# ====================================================================================================================
; Name...........: _StringBetween
; Author ........: SmOke_N
; ===============================================================================================================================
Func _StringBetween($sString, $sStart, $sEnd, $vCase = -1, $iSRE = -1)
	If $iSRE = -1 Or $iSRE = Default Then
		If $vCase = -1 Or $vCase = Default Then
			$vCase = 0
		Else
			$vCase = 1
		EndIf
		Local $sHold = '', $sSnSStart = '', $sSnSEnd = ''
		While StringLen($sString) > 0
			$sSnSStart = StringInStr($sString, $sStart, $vCase)
			If Not $sSnSStart Then ExitLoop
			$sString = StringTrimLeft($sString, ($sSnSStart + StringLen($sStart)) - 1)
			$sSnSEnd = StringInStr($sString, $sEnd, $vCase)
			If Not $sSnSEnd Then ExitLoop
			$sHold &= StringLeft($sString, $sSnSEnd - 1) & Chr(1)
			$sString = StringTrimLeft($sString, $sSnSEnd)
		WEnd
		If Not $sHold Then Return SetError(1, 0, 0)
		$sHold = StringSplit(StringTrimRight($sHold, 1), Chr(1))
		Local $avArray[UBound($sHold) - 1]
		For $iCC = 1 To UBound($sHold) - 1
			$avArray[$iCC - 1] = $sHold[$iCC]
		Next
		Return $avArray
	Else
		If $vCase = Default Or $vCase = -1 Then
			$vCase = '(?i)'
		Else
			$vCase = ''
		EndIf
		Local $aArray = StringRegExp($sString, '(?s)' & $vCase & $sStart & '(.*?)' & $sEnd, 3)
		If IsArray($aArray) Then Return $aArray
		Return SetError(1, 0, 0)
	EndIf
EndFunc   ;==>_StringBetween
#EndRegion Include